/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.NumberTableCellEditor;
import gui.SecData;
import gui.SpreadSheetTableModel;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DatData
extends SpreadSheetTableModel {
    public static FromAboveTableCellRenderer fromAboveRend = new FromAboveTableCellRenderer();
    public AbundanceTableCellRenderer abundanceRend = new AbundanceTableCellRenderer();
    public static NumberTableCellEditor absoluteAbundEditor = new NumberTableCellEditor(5, 2, false);
    public SecData.SectionRow secData;
    public boolean noEmptyRows = false;
    public static final int RELATIVE = 1;
    public static final int ABSOLUTE = 2;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public DatData(SecData.SectionRow sd) {
        this.columnNames.add("Fossil #");
        this.columnNames.add("Depth");
        this.columnNames.add("Abundance");
        this.columnNames.add("Type");
        this.secData = sd;
    }

    public void fireAbundanceTypeChanged() {
        this.fireTableDataChanged();
    }

    public int getAbundanceType() {
        if (this.secData != null) {
            return this.secData.getATint();
        }
        return 1;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("gui.DatData$Abundance");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("gui.DatData$Type");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void addWellData(boolean buddy, int id, float depth) {
        DataRow row = new DataRow();
        row.setID(id);
        if (buddy) {
            row.setBuddy();
        } else {
            row.forceDepth(depth);
        }
        this.data.add(row);
        this.fireTableRowsInserted(this.data.size() - 2, this.data.size() - 1);
    }

    public void addRow(DataRow row) {
        this.data.add(row);
    }

    public void multiplyDepths(float factor) {
        int i = 0;
        while (i < this.data.size()) {
            DataRow row = (DataRow)this.data.get(i);
            if (!row.getBuddy()) {
                row.setDepth(row.getDepth() * factor);
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void modifyWellData(int which, float depth, boolean noZeros) {
        DataRow row;
        boolean failed = true;
        int sampleCount = -1;
        int i = 0;
        while (sampleCount < which && i < this.data.size()) {
            row = (DataRow)this.data.get(i);
            if (!row.isIncomplete() && !row.getBuddy() && ++sampleCount == which) {
                failed = false;
                break;
            }
            ++i;
        }
        if (failed) {
            if (!noZeros || depth != 0.0f) {
                row = new DataRow();
                row.setID(0);
                row.setDepth(depth);
                this.data.insertElementAt(row, i);
                this.fireTableRowsInserted(i, i + 1);
            }
        } else {
            row = (DataRow)this.data.get(i);
            row.setDepth(depth);
        }
    }

    public void addRows(int numRows) {
        int start = this.data.size();
        if (start < 0) {
            start = 0;
        }
        this.addRows(numRows, start);
    }

    public String addRows(int numRows, int startRow) {
        int i = 0;
        while (i < numRows) {
            this.data.insertElementAt(new DataRow(), startRow);
            ++i;
        }
        this.fireTableRowsInserted(startRow, startRow + numRows);
        return null;
    }

    public String removeRows(int[] rows) {
        super.removeRows(rows);
        this.makeEmptyRows();
        return null;
    }

    public TableCellRenderer getTableCellRenderer(int row, int column) {
        DataRow r = (DataRow)this.getRow(row);
        if (column == 1 && r.getBuddy()) {
            return fromAboveRend;
        }
        if (column == 2 && this.getAbundanceType() == 2) {
            return super.getTableCellRenderer(row, column);
        }
        return super.getTableCellRenderer(row, column);
    }

    public void makeEmptyRows() {
        if (this.noEmptyRows) {
            return;
        }
        int numEmpties = 0;
        int i = 0;
        while (i < this.data.size() && i < 5) {
            DataRow row = (DataRow)this.getRow(this.data.size() - i - 1);
            if (row.getID() != -1) break;
            ++numEmpties;
            ++i;
        }
        if (numEmpties < 5) {
            this.addRows(5 - numEmpties);
        }
    }

    public void sortDepths(int dir) {
        float lastDepth = 0.0f;
        int i = 0;
        while (i < this.data.size()) {
            DataRow row = (DataRow)this.getRow(i);
            if (!row.getBuddy()) {
                lastDepth = row.getDepth();
            }
            row.tempDepth = lastDepth;
            ++i;
        }
        Collections.sort(this.data, new DepthComparator(dir == 1 ? 1 : -1));
        this.fireTableDataChanged();
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 1 && value != null) {
            try {
                float d = Float.parseFloat(value.toString());
                if (d == 0.0f) {
                    value = null;
                }
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        if (col == 2 && value instanceof String) {
            value = Abundance.fromString(value.toString());
        }
        super.setValueAt(value, row, col);
        this.makeEmptyRows();
    }

    public static class Abundance {
        float abund;
        public static final float NONE = 0.0f;
        public static final float RARE = 5.0f;
        public static final float COMMON = 20.0f;
        public static final float FREQUENT = 50.0f;
        public static final float ABUNDANT = 100.0f;
        public static final float FLOOD = 101.0f;

        public Abundance(float a) {
            this.setAbundance(a);
        }

        public void setAbundance(float a) {
            this.abund = a;
        }

        public float getAbundance() {
            return this.abund;
        }

        public String toString() {
            if (this.abund == 0.0f) {
                return "";
            }
            if (this.abund <= 5.0f) {
                return "rare";
            }
            if (this.abund <= 20.0f) {
                return "common";
            }
            if (this.abund <= 50.0f) {
                return "frequent";
            }
            if (this.abund <= 100.0f) {
                return "abundant";
            }
            if (this.abund > 100.0f) {
                return "flood";
            }
            return "";
        }

        public static Abundance fromString(String s) {
            float f;
            block9: {
                try {
                    f = Float.parseFloat(s);
                    if (f != 0.0f) break block9;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    if (s.length() == 0) {
                        return new Abundance(0.0f);
                    }
                    if (s.compareToIgnoreCase("rare") == 0) {
                        return new Abundance(5.0f);
                    }
                    if (s.compareToIgnoreCase("common") == 0) {
                        return new Abundance(20.0f);
                    }
                    if (s.compareToIgnoreCase("frequent") == 0) {
                        return new Abundance(50.0f);
                    }
                    if (s.compareToIgnoreCase("abundant") == 0) {
                        return new Abundance(100.0f);
                    }
                    if (s.compareToIgnoreCase("flood") == 0) {
                        return new Abundance(101.0f);
                    }
                    return new Abundance(0.0f);
                }
            }
            return new Abundance(f);
        }

        public static JComboBox getCombo() {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("");
            comboBox.addItem("rare");
            comboBox.addItem("common");
            comboBox.addItem("frequent");
            comboBox.addItem("abundant");
            comboBox.addItem("flood");
            return comboBox;
        }
    }

    public static class AbundanceTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        public int type = 1;

        public void setType(int t) {
            this.type = t;
        }

        public void setValue(Object value) {
            Abundance ab = (Abundance)value;
            if (ab == null || ab.getAbundance() == 0.0f) {
                this.setText("");
            } else if (this.type == 1) {
                this.setText(ab.toString());
            } else {
                this.setText("" + ab.getAbundance());
            }
        }
    }

    public static class DataRow
    extends SpreadSheetTableModel.Row {
        public float tempDepth;

        public DataRow() {
            this.cells.setSize(4);
            this.cells.set(0, null);
        }

        public void setID(int id) {
            if (id == -1) {
                this.cells.set(0, null);
            } else {
                this.cells.set(0, new Integer(id));
            }
        }

        public void setBuddy() {
            this.cells.set(1, null);
        }

        public void setDepth(float depth) {
            if (depth == 0.0f) {
                this.cells.set(1, null);
            } else {
                this.cells.set(1, new Float(depth));
            }
        }

        public void forceDepth(float depth) {
            this.cells.set(1, new Float(depth));
        }

        public float getDepth() {
            Object o = this.getCol(1);
            if (o == null) {
                return 0.0f;
            }
            return ((Float)o).floatValue();
        }

        public boolean isIncomplete() {
            return this.getID() < 0;
        }

        public int getID() {
            Object o = this.getCol(0);
            if (o == null) {
                return -1;
            }
            return (Integer)o;
        }

        public boolean getBuddy() {
            Object o = this.getCol(1);
            return o == null || o.toString().trim().length() == 0;
        }

        public void setAbundanceFloat(float f) {
            if (f == 0.0f) {
                this.cells.set(2, null);
            } else {
                this.cells.set(2, new Abundance(f));
            }
        }

        public float getAbundanceFloat() {
            Abundance a = (Abundance)this.getCol(2);
            if (a == null) {
                return 0.0f;
            }
            return a.abund;
        }

        public String getType() {
            Object o = this.cells.get(3);
            if (o == null) {
                return null;
            }
            return o.toString();
        }

        public void setType(String s) {
            this.cells.set(3, s);
        }
    }

    public static class DepthComparator
    implements Comparator {
        int mul = 1;

        public DepthComparator(int mul) {
            this.mul = mul;
        }

        public int compare(Object arg0, Object arg1) {
            DataRow left = (DataRow)arg0;
            DataRow right = (DataRow)arg1;
            if (left.isIncomplete() && right.isIncomplete()) {
                return 0;
            }
            if (left.isIncomplete()) {
                return 1;
            }
            if (right.isIncomplete()) {
                return -1;
            }
            float ret = (left.tempDepth - right.tempDepth) * (float)this.mul;
            if (ret > 0.0f) {
                return 1;
            }
            if (ret < 0.0f) {
                return -1;
            }
            return 0;
        }
    }

    public static class FromAboveTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        public FromAboveTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setText("\u2191\u2191\u2191");
        }
    }

    public static class Type {
        public static String getShort(String l) {
            if (l == null || l.length() == 0) {
                return "";
            }
            int i = l.indexOf(32);
            if (i < 0) {
                return l;
            }
            return l.substring(0, i);
        }

        public static JComboBox getComboBox() {
            JComboBox<String> cb = new JComboBox<String>();
            cb.addItem("");
            cb.addItem("CTS cutting's sample");
            cb.addItem("SWC site wall core");
            cb.addItem("C core");
            cb.addItem("O other");
            return cb;
        }
    }
}

