/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.NumberTableCellEditor;
import gui.SpreadSheetTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DictionaryData
extends SpreadSheetTableModel {
    public static final int NUM_ENTRIES = 998;
    public static final int NULL = -1;
    public static NumberTableCellEditor idEditor = new NumberTableCellEditor(3, 0, false);
    JTableHeader header = null;
    MouseHandler mouseListener = new MouseHandler();
    public int numUE = 0;
    public int numMH = 0;
    public boolean UEDisabled = false;
    public boolean MHDisabled = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public DictionaryData() {
        this.data.ensureCapacity(998);
        this.columnNames.add("Fossil #");
        this.columnNames.add("Fossil Name");
        this.columnNames.add("Nickname");
        this.columnNames.add("count");
        this.columnNames.add("UE");
        this.columnNames.add("MH");
        this.columnNames.add("Microfossil Group");
        this.columnNames.add("Optional");
        this.columnNames.add("Optional");
        this.clear();
    }

    public void setUE(int id, boolean tf) {
        Iterator dicIter = this.data.iterator();
        while (dicIter.hasNext()) {
            DicRow row = (DicRow)dicIter.next();
            if (row.getID() != id) continue;
            row.setUE(tf);
            break;
        }
    }

    public void setMH(int id, boolean tf) {
        Iterator dicIter = this.data.iterator();
        while (dicIter.hasNext()) {
            DicRow row = (DicRow)dicIter.next();
            if (row.getID() != id) continue;
            row.setMH(tf);
            break;
        }
    }

    public void clear() {
        this.data.removeAllElements();
        int i = 0;
        while (i < 998) {
            DicRow row = new DicRow();
            row.setName("");
            row.setID(-1);
            this.data.add(row);
            ++i;
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("gui.DictionaryData$FossilID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("gui.DictionaryData$MicroFossilGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 8: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int row, int col) {
        return col != 3;
    }

    public void set(int index, String name, int id) {
        DicRow row = (DicRow)this.getRow(index);
        row.setName(name);
        row.setID(id);
    }

    public void setRow(int index, DicRow row) {
        this.data.set(index, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicRow getRowByID(int id) {
        Vector vector = this.data;
        synchronized (vector) {
            Iterator iter = this.data.iterator();
            while (iter.hasNext()) {
                DicRow row = (DicRow)iter.next();
                if (row.getID() != id) continue;
                return row;
            }
        }
        return null;
    }

    public String addRows(int numRows, int startRow) {
        int rowsAdded = 0;
        int i = 0;
        while (i < numRows) {
            DicRow last = (DicRow)this.data.lastElement();
            if (last.isPracticallyEmpty()) {
                this.data.insertElementAt(new DicRow(), startRow);
                this.data.remove(this.data.size() - 1);
                ++rowsAdded;
            } else {
                this.fireTableRowsInserted(startRow, startRow + rowsAdded);
                return "Cannot insert another row because the last row would be removed, but it is non empty. Clear the last row to insert. <br>Only 998 rows are allowed (RASC limit).";
            }
            ++i;
        }
        this.fireTableRowsInserted(startRow, startRow + rowsAdded);
        return null;
    }

    public String removeRows(int[] rows) {
        int i = rows.length - 1;
        while (i >= 0) {
            this.data.removeElementAt(rows[i]);
            this.data.add(new DicRow());
            this.fireTableRowsDeleted(rows[i], rows[i]);
            --i;
        }
        return null;
    }

    public TableCellRenderer getTableCellRenderer(int row, int column) {
        DicRow r;
        if (column == 0 && (r = (DicRow)this.getRow(row)).getID() == -1) {
            return this.emptyRend;
        }
        return super.getTableCellRenderer(row, column);
    }

    public void setTableHeader(JTableHeader h) {
        if (this.header != null) {
            this.header.removeMouseListener(this.mouseListener);
        }
        this.header = h;
        if (this.header != null) {
            h.addMouseListener(this.mouseListener);
        }
    }

    public void sortColumn(int which) {
        Collections.sort(this.data, new ColumnSorter(which));
        this.fireTableDataChanged();
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0 && value != null) {
            try {
                value = new Integer(value.toString());
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        super.setValueAt(value, row, col);
    }

    private void dumpData() {
        Iterator iter = this.data.iterator();
        while (iter.hasNext()) {
            DicRow row = (DicRow)iter.next();
            System.out.println(row.getID() + "   " + row.getName());
        }
    }

    private class ColumnSorter
    implements Comparator {
        int col;

        public int compare(Object leftRow, Object rightRow) {
            String r;
            String l;
            Object left = ((SpreadSheetTableModel.Row)leftRow).getCol(this.col);
            Object right = ((SpreadSheetTableModel.Row)rightRow).getCol(this.col);
            if (left instanceof String && (l = left.toString()).trim().length() == 0) {
                left = null;
            }
            if (right instanceof String && (r = right.toString()).trim().length() == 0) {
                right = null;
            }
            if (left instanceof Integer && (Integer)left == -1) {
                left = null;
            }
            if (right instanceof Integer && (Integer)right == -1) {
                right = null;
            }
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            if (left instanceof String && right instanceof String) {
                return left.toString().compareToIgnoreCase(right.toString());
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo(right);
            }
            return 0;
        }

        ColumnSorter(int which) {
            this.col = which;
        }
    }

    public static class DicRow
    extends SpreadSheetTableModel.Row {
        int tempCount;

        public DicRow() {
            this.cells.setSize(9);
            this.setID(-1);
            this.cells.set(1, "");
            this.cells.set(2, "");
            this.cells.set(3, null);
            this.cells.set(4, new Boolean(false));
            this.cells.set(5, new Boolean(false));
            this.cells.set(6, "");
            this.cells.set(7, "");
            this.cells.set(8, "");
        }

        public DicRow(DicRow other) {
            this.cells = (Vector)other.cells.clone();
        }

        public boolean isPracticallyEmpty() {
            String name = this.getName();
            int id = this.getID();
            return (name == null || name.trim().length() == 0) && id == -1;
        }

        public void setName(String name) {
            this.cells.set(1, name);
        }

        public void setID(int id) {
            if (id == 999) {
                id = 998;
            }
            if (id < 0) {
                this.cells.set(0, null);
            } else {
                this.cells.set(0, new Integer(id));
            }
        }

        public String getName() {
            return this.getCol(1).toString();
        }

        public int getID() {
            Object o = this.getCol(0);
            if (o == null || !(o instanceof Integer)) {
                return -1;
            }
            return (Integer)this.getCol(0);
        }

        public void setNickname(String name) {
            this.cells.set(2, name);
        }

        public String getNickname() {
            return this.getCol(2).toString();
        }

        public void setCount(int c) {
            if (c == 0) {
                this.cells.set(3, null);
            } else {
                this.cells.set(3, new Integer(c));
            }
        }

        public int getCount() {
            Object o = this.cells.get(3);
            if (o == null) {
                return 0;
            }
            return (Integer)o;
        }

        public void setUE(boolean tf) {
            this.cells.set(4, new Boolean(tf));
        }

        public boolean getUE() {
            Object o = this.getCol(4);
            if (o == null || !(o instanceof Boolean)) {
                return false;
            }
            return (Boolean)o;
        }

        public void setMH(boolean tf) {
            this.cells.set(5, new Boolean(tf));
        }

        public boolean getMH() {
            Object o = this.getCol(5);
            if (o == null || !(o instanceof Boolean)) {
                return false;
            }
            return (Boolean)o;
        }

        public String getMFG() {
            Object o = this.cells.get(6);
            if (o == null) {
                return null;
            }
            return o.toString();
        }

        public void setMFG(String s) {
            this.cells.set(6, s);
        }

        public void setOpt1(String opt) {
            this.cells.set(7, opt);
        }

        public String getOpt1() {
            return this.cells.get(7).toString();
        }

        public void setOpt2(String opt) {
            this.cells.set(8, opt);
        }

        public String getOpt2() {
            return this.cells.get(8).toString();
        }
    }

    public static class FossilID {
    }

    public static class MicroFossilGroup {
        public static JComboBox getComboBox() {
            JComboBox<String> cb = new JComboBox<String>();
            cb.addItem("");
            cb.addItem("AC Acritarchs");
            cb.addItem("DC Dinoflagellate cysts");
            cb.addItem("ABF Agglutinated benthic foraminifers");
            cb.addItem("CBF Calcareous benthic foraminifers");
            cb.addItem("PF Planktonic foraminifers");
            cb.addItem("DI Diatoms");
            cb.addItem("NA Nannofossils");
            cb.addItem("CA Bolboforma and other calcareous algae");
            cb.addItem("OS Ostracods");
            cb.addItem("RA Radiolarians");
            cb.addItem("SP Spores, pollen");
            cb.addItem("MM Miscellaneous (everything else)");
            return cb;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1 && column >= 0 && column <= 3) {
                DictionaryData.this.sortColumn(column);
            }
        }
    }
}

