/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DatData;
import gui.Document;
import gui.SecData;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DupeChecker {
    public static boolean shouldSave(Document doc) {
        List dupes = DupeChecker.findDupes(doc);
        if (dupes.size() != 0) {
            String dupeS = "";
            Iterator dupeIter = dupes.iterator();
            int i = 0;
            while (dupeIter.hasNext() && i < 10) {
                dupeS = String.valueOf(dupeS) + dupeIter.next().toString() + "\r\n";
                ++i;
            }
            if (dupeIter.hasNext()) {
                dupeS = String.valueOf(dupeS) + "...";
            }
            Object[] options = new String[]{"Save anyway", "Cancel"};
            int option = JOptionPane.showOptionDialog(null, "There are some duplicate fossils in some sections. RASC may crash on this:\r\n" + dupeS, "ERROR", -1, 0, null, options, options[1]);
            if (option == 1 || option == -1) {
                return false;
            }
        }
        return true;
    }

    protected static List findDupes(Document doc) {
        Vector<Dupe> ret = new Vector<Dupe>();
        Iterator secIter = doc.sec.iterator();
        while (secIter.hasNext()) {
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            Object[] data = new DatData.DataRow[]{};
            data = (DatData.DataRow[])section.datData.getDataArray(data);
            int i = 0;
            while (i < data.length) {
                if (!((DatData.DataRow)data[i]).isIncomplete()) {
                    int id = ((DatData.DataRow)data[i]).getID();
                    int j = i + 1;
                    while (j < data.length) {
                        if (!((DatData.DataRow)data[j]).isIncomplete() && ((DatData.DataRow)data[j]).getID() == id) {
                            ret.add(new Dupe((DatData.DataRow)data[j], DupeChecker.getDepth((DatData.DataRow[])data, j), (DatData.DataRow)data[i], DupeChecker.getDepth((DatData.DataRow[])data, i), section));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public static float getDepth(DatData.DataRow[] data, int i) {
        DatData.DataRow row = data[i];
        if (row.getBuddy()) {
            while (i >= 0) {
                if (!data[i].getBuddy()) {
                    return data[i].getDepth();
                }
                --i;
            }
            return 0.0f;
        }
        return row.getDepth();
    }

    protected static class Dupe {
        DatData.DataRow dupe;
        DatData.DataRow orig;
        SecData.SectionRow section;
        float dupeDepth;
        float origDepth;

        public Dupe(DatData.DataRow dupe, float dupeDepth, DatData.DataRow orig, float origDepth, SecData.SectionRow section) {
            this.dupe = dupe;
            this.orig = orig;
            this.section = section;
            this.dupeDepth = dupeDepth;
            this.origDepth = origDepth;
        }

        public String toString() {
            return String.valueOf(this.section.getName()) + ": " + this.dupe.getID() + " at depth " + this.dupeDepth + " first appears at depth " + this.origDepth;
        }
    }
}

