/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberTableCellEditor
extends DefaultCellEditor
implements FocusListener {
    public NumberTableCellEditor(int numDigits, int maxFraction, boolean allowNeg) {
        super(new NumberField(numDigits, maxFraction, allowNeg));
        this.getComponent().addFocusListener(this);
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this.stopCellEditing();
    }

    protected static class NumberField
    extends JTextField {
        int maxDigits;
        int maxFraction;
        boolean allowNeg;

        public NumberField(int numDigits, int maxFraction, boolean allowNeg) {
            this.maxDigits = numDigits;
            this.maxFraction = maxFraction;
            this.allowNeg = allowNeg;
        }

        protected Document createDefaultModel() {
            return new NumberDocument(this.maxDigits, this.maxFraction, this.allowNeg);
        }

        static class NumberDocument
        extends PlainDocument {
            int maxDigits;
            int maxFraction;
            boolean allowNeg;

            public NumberDocument(int maxD, int maxF, boolean allowN) {
                this.maxDigits = maxD;
                this.maxFraction = maxF;
                this.allowNeg = allowN;
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String vexed = "";
                int i = 0;
                while (i < str.length()) {
                    char c = str.charAt(i);
                    if (Character.isDigit(c) || this.maxFraction > 0 && c == '.' || this.allowNeg && c == '-') {
                        vexed = String.valueOf(vexed) + c;
                    }
                    ++i;
                }
                super.insertString(offs, vexed, a);
            }
        }
    }
}

