/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DatData;
import gui.DatPage;
import gui.QSCreator;
import gui.SpreadSheetTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SecData
extends SpreadSheetTableModel {
    public static final int RELATIVE = 1;
    public static final int ABSOLUTE = 2;
    DisplayMeTableCellRenderer dispMeRend = new DisplayMeTableCellRenderer();
    ButtonTableCellRenderer buttonRend = new ButtonTableCellRenderer();
    public SectionRow selectedRow;
    public DatPage datPage;
    QSCreator qsc;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public SecData(QSCreator q) {
        this.qsc = q;
        this.columnNames.add("Edit");
        this.columnNames.add("Nickname");
        this.columnNames.add("Section Name");
        this.columnNames.add("Unit");
        this.columnNames.add("WD");
        this.columnNames.add("Height RT");
        this.columnNames.add("Abundance");
        this.columnNames.add("Sort Depth");
        this.columnNames.add("Sort Depth");
        this.columnNames.add("Reorder");
        this.columnNames.add("Reorder");
        this.columnNames.add("");
        this.selectedRow = new SectionRow();
        this.data.add(this.selectedRow);
        this.selectedRow.datData = new DatData(this.selectedRow);
        this.selectedRow.datData.makeEmptyRows();
    }

    public SectionRow createNewWell(boolean emptyRows) {
        this.selectedRow = new SectionRow();
        this.data.add(this.selectedRow);
        this.selectedRow.datData = new DatData(this.selectedRow);
        if (emptyRows) {
            this.selectedRow.datData.makeEmptyRows();
        }
        this.displayDat(this.selectedRow);
        return this.selectedRow;
    }

    public void clear() {
        this.data.removeAllElements();
        this.fireTableDataChanged();
        this.displayDat(null);
    }

    public void setDatPage(DatPage datPage) {
        this.datPage = datPage;
        this.displayDat(this.selectedRow);
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("gui.SecData$SectionRow$DisplayMe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("gui.SecData$Unit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("gui.SecData$AbundanceType");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("gui.SecData$SectionRow$Button");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 8: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("gui.SecData$SectionRow$Button");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 9: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("gui.SecData$SectionRow$Button");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 10: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("gui.SecData$SectionRow$Button");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 11: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("gui.SecData$SectionRow$Button");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void displayDat(SectionRow row) {
        this.selectedRow = row;
        if (row != null) {
            this.datPage.setDat(row.datData);
        } else {
            this.datPage.setDat(null);
        }
        this.fireAbundanceTypeChanged();
        this.fireTableDataChanged();
    }

    public DatData getFirstDat() {
        return ((SectionRow)this.data.get((int)0)).datData;
    }

    public SectionRow getSelectedRow() {
        return this.selectedRow;
    }

    public void fireAbundanceTypeChanged() {
        this.qsc.ATUpdated.doAction();
    }

    public SectionRow getRow(String name, boolean create) {
        SectionRow row;
        Iterator iter = this.data.iterator();
        while (iter.hasNext()) {
            row = (SectionRow)iter.next();
            if (row.getName().compareToIgnoreCase(name.trim()) != 0) continue;
            return row;
        }
        if (create) {
            row = new SectionRow();
            row.setName(name);
            this.data.add(row);
            return row;
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 3 && value instanceof String) {
            String s = value.toString();
            Unit newUnit = s.compareToIgnoreCase("feet") == 0 ? new Unit('f') : new Unit('m');
            value = newUnit;
            if (newUnit.getUnit() != ((SectionRow)this.getRow(row)).getUnit().charAt(0)) {
                if (newUnit.getUnit() == 'm') {
                    ((SectionRow)this.getRow((int)row)).datData.multiplyDepths(0.3048f);
                } else {
                    ((SectionRow)this.getRow((int)row)).datData.multiplyDepths(3.28084f);
                }
            }
        }
        if (col == 6) {
            SectionRow secrow = (SectionRow)this.getRow(row);
            value = value.toString().compareToIgnoreCase("absolute") == 0 ? new AbundanceType(2) : new AbundanceType(1);
            super.setValueAt(value, row, col);
            secrow.datData.fireAbundanceTypeChanged();
            this.fireAbundanceTypeChanged();
            return;
        }
        if (col == 0 || col >= 7) {
            return;
        }
        super.setValueAt(value, row, col);
    }

    public static class AbundanceType {
        int val;

        public AbundanceType(int at) {
            this.setAT(at);
        }

        public AbundanceType(char u) {
            this.setAT(u);
        }

        public void setAT(char u) {
            if (u != 'a' && u != 'r') {
                u = (char)114;
            }
            this.val = u == 'a' ? 2 : 1;
        }

        public void setAT(int at) {
            if (at != 2 && at != 1) {
                at = 1;
            }
            this.val = at;
        }

        public int getAT() {
            return this.val;
        }

        public String toString() {
            if (this.val == 2) {
                return "absolute";
            }
            return "relative";
        }

        public static JComboBox getCombo() {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("absolute");
            comboBox.addItem("relative");
            return comboBox;
        }
    }

    public class ButtonTableCellRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        JButton button = new JButton();
        Object editedObj = null;

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o = SecData.this.getRow(row).getCol(column);
            if (!(o instanceof SectionRow.Button)) {
                return new JPanel();
            }
            SectionRow.Button b = (SectionRow.Button)o;
            this.button.setText(b.label);
            this.button.setEnabled(b.isEnabled(table, row, column));
            return this.button;
        }

        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int column) {
            Object o;
            JButton button = new JButton("haha");
            button.addActionListener(new ActionListener(this){
                final /* synthetic */ ButtonTableCellRenderer this$1;
                {
                    this.this$1 = buttonTableCellRenderer;
                }

                public void actionPerformed(ActionEvent arg0) {
                    ButtonTableCellRenderer.access$0(this.this$1);
                }
            });
            this.editedObj = o = SecData.this.getRow(row).getCol(column);
            if (o instanceof SectionRow.Button) {
                SectionRow.Button b = (SectionRow.Button)o;
                button.setText(b.label);
                button.setEnabled(b.isEnabled(table, row, column));
                button.addActionListener(b.getActionListener());
            }
            return button;
        }

        public Object getCellEditorValue() {
            return this.editedObj;
        }

        static /* synthetic */ void access$0(ButtonTableCellRenderer buttonTableCellRenderer) {
            buttonTableCellRenderer.fireEditingStopped();
        }
    }

    public class DisplayMeTableCellRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        JToggleButton toggle = new JToggleButton("<< Edit");
        Object editedObj = null;

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o = SecData.this.getRow(row).getCol(column);
            if (!(o instanceof SectionRow.DisplayMe)) {
                return new JPanel();
            }
            this.toggle.setSelected(((SectionRow.DisplayMe)o).isSelected());
            return this.toggle;
        }

        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int column) {
            Object o;
            JToggleButton toggle = new JToggleButton("<< Edit");
            this.editedObj = o = SecData.this.getRow(row).getCol(column);
            if (!(o instanceof SectionRow.DisplayMe)) {
                return new JPanel();
            }
            toggle.setSelected(((SectionRow.DisplayMe)o).isSelected());
            toggle.addActionListener(((SectionRow.DisplayMe)o).getActionListener());
            return toggle;
        }

        public Object getCellEditorValue() {
            return this.editedObj;
        }
    }

    public class SectionRow
    extends SpreadSheetTableModel.Row {
        public DatData datData;

        public SectionRow() {
            this.cells.setSize(12);
            this.datData = new DatData(this);
            this.setAT('r');
            this.setUnit("m");
            this.setName("unknown name");
            this.setNickname(null);
            this.setWaterDepth(0.0f);
            this.setHeightRotTabl(0.0f);
            this.createDisplayMe();
            this.createButtons();
        }

        public void createDisplayMe() {
            this.cells.set(0, new DisplayMe());
        }

        public void setNickname(String name) {
            this.cells.set(1, name);
        }

        public String getNickname() {
            if (this.cells.get(1) == null) {
                return null;
            }
            return this.cells.get(1).toString();
        }

        public void setName(String name) {
            this.cells.set(2, name);
            if (this.getNickname() == null) {
                this.setNickname(name.substring(0, Math.min(3, name.length())));
            }
        }

        public String getName() {
            return this.cells.get(2).toString();
        }

        public void setUnit(String unit) {
            if ((unit = unit.trim()).length() == 0) {
                unit = "m";
            }
            this.cells.set(3, new Unit(unit.charAt(0)));
        }

        public String getUnit() {
            Object o = this.cells.get(3);
            if (o == null) {
                return "m";
            }
            return "" + ((Unit)o).getUnit();
        }

        public void setWaterDepth(float d) {
            this.cells.set(4, new Float(d));
        }

        public float getWaterDepth() {
            Object o = this.cells.get(4);
            if (o == null) {
                return 0.0f;
            }
            return ((Float)o).floatValue();
        }

        public void setHeightRotTabl(float d) {
            this.cells.set(5, new Float(d));
        }

        public float getHeightRotTabl() {
            Object o = this.cells.get(5);
            if (o == null) {
                return 0.0f;
            }
            return ((Float)o).floatValue();
        }

        public void setAT(char at) {
            this.cells.set(6, new AbundanceType(at));
            this.datData.fireAbundanceTypeChanged();
        }

        public AbundanceType getAT() {
            return (AbundanceType)this.cells.get(6);
        }

        public int getATint() {
            AbundanceType at = (AbundanceType)this.cells.get(6);
            if (at == null) {
                return 1;
            }
            return at.val;
        }

        public void createButtons() {
            Button sortASC = new Button("ASC");
            Button sortDESC = new Button("DESC");
            Button up = new Button("UP");
            Button down = new Button("DOWN");
            Button del = new Button("delete");
            this.cells.set(7, sortASC);
            this.cells.set(8, sortDESC);
            this.cells.set(9, up);
            this.cells.set(10, down);
            this.cells.set(11, del);
            up.disabledFirst = true;
            down.disabledLast = true;
            del.disabledOnly = true;
            sortASC.setActionListener(new ActionListener(this){
                final /* synthetic */ SectionRow this$1;
                {
                    this.this$1 = sectionRow;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.datData.sortDepths(1);
                }
            });
            sortDESC.setActionListener(new ActionListener(this){
                final /* synthetic */ SectionRow this$1;
                {
                    this.this$1 = sectionRow;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.datData.sortDepths(2);
                }
            });
            up.setActionListener(new ActionListener(this){
                final /* synthetic */ SectionRow this$1;
                {
                    this.this$1 = sectionRow;
                }

                public void actionPerformed(ActionEvent arg0) {
                    int myIndex = SectionRow.access$0((SectionRow)this.this$1).data.indexOf(this.this$1);
                    if (myIndex == 0) {
                        return;
                    }
                    SectionRow.access$0((SectionRow)this.this$1).data.insertElementAt(SectionRow.access$0((SectionRow)this.this$1).data.remove(myIndex), myIndex - 1);
                    SectionRow.access$0(this.this$1).fireTableRowsUpdated(myIndex - 1, myIndex);
                }
            });
            down.setActionListener(new ActionListener(this){
                final /* synthetic */ SectionRow this$1;
                {
                    this.this$1 = sectionRow;
                }

                public void actionPerformed(ActionEvent arg0) {
                    int myIndex = SectionRow.access$0((SectionRow)this.this$1).data.indexOf(this.this$1);
                    SectionRow.access$0((SectionRow)this.this$1).data.insertElementAt(SectionRow.access$0((SectionRow)this.this$1).data.remove(myIndex), myIndex + 1);
                    SectionRow.access$0(this.this$1).fireTableRowsUpdated(myIndex, myIndex + 1);
                }
            });
            del.setActionListener(new ActionListener(this){
                final /* synthetic */ SectionRow this$1;
                {
                    this.this$1 = sectionRow;
                }

                public void actionPerformed(ActionEvent arg0) {
                    int myIndex = SectionRow.access$0((SectionRow)this.this$1).data.indexOf(this.this$1);
                    SectionRow.access$0((SectionRow)this.this$1).data.remove(myIndex);
                    SectionRow.access$0(this.this$1).fireTableDataChanged();
                    if (myIndex >= SectionRow.access$0((SectionRow)this.this$1).data.size()) {
                        myIndex = SectionRow.access$0((SectionRow)this.this$1).data.size() - 1;
                    }
                    if (myIndex >= 0) {
                        SectionRow.access$0((SectionRow)this.this$1).selectedRow = (SectionRow)SectionRow.access$0((SectionRow)this.this$1).data.get(myIndex);
                        SectionRow.access$0(this.this$1).displayDat(SectionRow.access$0((SectionRow)this.this$1).selectedRow);
                    } else {
                        SectionRow.access$0(this.this$1).displayDat(null);
                    }
                }
            });
        }

        public class Button {
            public String label;
            public boolean disabledFirst = false;
            public boolean disabledLast = false;
            public boolean disabledOnly = false;
            ActionListener listener = new ActionListener(this){
                final /* synthetic */ Button this$2;
                {
                    this.this$2 = button;
                }

                public void actionPerformed(ActionEvent arg0) {
                }
            };

            public Button(String label) {
                this.label = label;
            }

            public boolean isEnabled(JTable table, int row, int col) {
                if (this.disabledFirst && row == 0) {
                    return false;
                }
                if (this.disabledLast && row == table.getRowCount() - 1) {
                    return false;
                }
                return !this.disabledOnly || table.getRowCount() != 1;
            }

            public void setActionListener(ActionListener l) {
                this.listener = l;
            }

            public ActionListener getActionListener() {
                return this.listener;
            }
        }

        public class DisplayMe {
            ActionListener listener = new ActionListener(this){
                final /* synthetic */ DisplayMe this$2;
                {
                    this.this$2 = displayMe;
                }

                public void actionPerformed(ActionEvent arg0) {
                    SectionRow.access$0(DisplayMe.access$0(this.this$2)).displayDat(DisplayMe.access$0(this.this$2));
                }
            };

            public ActionListener getActionListener() {
                return this.listener;
            }

            public boolean isSelected() {
                return SectionRow.this == SecData.this.getSelectedRow();
            }

            static /* synthetic */ SectionRow access$0(DisplayMe displayMe) {
                return displayMe.SectionRow.this;
            }
        }
    }

    public static class Unit {
        char unit;

        public Unit(char u) {
            this.setUnit(u);
        }

        public void setUnit(char u) {
            if (u == 'M') {
                u = (char)109;
            }
            if (u == 'F') {
                u = (char)102;
            }
            if (u != 'm' && u != 'f') {
                u = (char)109;
            }
            this.unit = u;
        }

        public char getUnit() {
            return this.unit;
        }

        public String toString() {
            if (this.unit == 'm') {
                return "meters";
            }
            return "feet";
        }

        public static JComboBox getCombo() {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("meters");
            comboBox.addItem("feet");
            return comboBox;
        }
    }
}

