/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class TableRowHeader
extends JComponent {
    JTable table;
    int totalWidth = 10;
    int margin;
    int widthMargin = 4;
    int rowHeight = 0;
    Font font;
    Color background = new Color(220, 220, 220);
    Color foreground = Color.BLACK;
    Border border;
    boolean skipPaint = false;

    public TableRowHeader(JTable tab) {
        this.table = tab;
        this.margin = this.table.getRowMargin();
        this.rowHeight = this.table.getRowHeight();
        TableCellRenderer aRenderer = this.table.getTableHeader().getDefaultRenderer();
        Component aComponent = aRenderer.getTableCellRendererComponent(this.table, "text", false, false, -1, 0);
        this.font = aComponent.getFont();
    }

    public void paint(Graphics g) {
        if (this.skipPaint) {
            return;
        }
        this.updateWidth(g);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics(this.font);
        int labelHeight = fm.getHeight();
        int labelDescent = fm.getDescent();
        int y = 0;
        Rectangle clip = g.getClipBounds();
        int startRow = clip.y / this.rowHeight;
        int endRow = startRow + clip.height / this.rowHeight + 2;
        int i = startRow;
        while (i < this.table.getRowCount() && i < endRow) {
            String text = "" + (i + 1);
            int labelWidth = fm.stringWidth(text);
            y = i * this.rowHeight;
            g.setColor(this.background);
            g.fillRect(0, y, this.totalWidth, this.rowHeight);
            int w = this.totalWidth - 2 * this.margin;
            int stringx = this.widthMargin / 2 + (w - labelWidth) / 2;
            g.setColor(this.foreground);
            g.drawString(text, stringx, y + this.rowHeight - (this.rowHeight - labelHeight) / 2 - labelDescent);
            g.setColor(Color.BLACK);
            g.drawLine(clip.x, y + this.rowHeight - 1, clip.width, y + this.rowHeight - 1);
            ++i;
        }
    }

    public void updateWidth(Graphics g) {
        this.skipPaint = true;
        FontMetrics fm = g.getFontMetrics(this.font);
        int oldWidth = this.totalWidth;
        int numChars = (int)Math.ceil(Math.log(this.table.getRowCount()) / Math.log(10.0));
        if (numChars <= 0) {
            numChars = 1;
        }
        String testLabel = "";
        int i = 0;
        while (i < numChars) {
            testLabel = String.valueOf(testLabel) + "0";
            ++i;
        }
        this.totalWidth = fm.stringWidth(testLabel) + this.widthMargin;
        if (oldWidth != this.totalWidth) {
            this.setSize(new Dimension(this.totalWidth, this.getTotalHeight()));
        }
        this.skipPaint = false;
    }

    public int getTotalHeight() {
        return this.rowHeight * this.table.getRowCount();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.totalWidth, this.getTotalHeight());
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.totalWidth, this.getTotalHeight());
    }
}

