/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.DatData;
import gui.DictionaryData;
import gui.Document;
import gui.SecData;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class SaveLST {
    public static void saveLST(Document doc, String filename) {
        Exception e = null;
        try {
            FileOutputStream lstOut = new FileOutputStream(filename);
            OutputStreamWriter w = new OutputStreamWriter(lstOut);
            SaveLST.saveLST(doc, w);
            ((Writer)w).close();
            lstOut.close();
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            Object[] options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "There was an error saving the LST file:\r\n" + e.getMessage(), "ERROR", -1, 3, null, options, options[0]);
        }
    }

    public static void saveLST(Document doc, Writer out) throws IOException {
        out.write("QSCreator List output\r\n\r\n\r\n");
        Iterator secIter = doc.sec.iterator();
        while (secIter.hasNext()) {
            SecData.SectionRow section = (SecData.SectionRow)secIter.next();
            out.write(String.valueOf(section.getName()) + "\r\n");
            out.write("Rotary table height: " + section.getHeightRotTabl() + " " + section.getUnit() + "\r\n");
            out.write("Water depth: " + section.getWaterDepth() + " " + section.getUnit() + "\r\n\r\n");
            out.write("Depth(m)/type   Event#/Freq.      Event (fossil) name          \r\n");
            out.write("---------------------------------------------------------------\r\n");
            Iterator dataIter = section.datData.iterator();
            while (dataIter.hasNext()) {
                String depth;
                DatData.DataRow data = (DatData.DataRow)dataIter.next();
                if (data.isIncomplete()) continue;
                if (data.getBuddy()) {
                    depth = "         " + SaveLST.fillSpaceRight(DatData.Type.getShort(data.getType()), 7);
                } else {
                    out.write("\r\n");
                    depth = String.valueOf(SaveLST.fillSpaceLeft("" + data.getDepth(), 8)) + "/" + SaveLST.fillSpaceRight(DatData.Type.getShort(data.getType()), 7);
                }
                out.write(depth);
                String abund = "";
                if (data.getAbundanceFloat() != 0.0f) {
                    abund = "" + data.getAbundanceFloat();
                }
                String event = String.valueOf(SaveLST.fillSpaceLeft("" + data.getID(), 6)) + "/" + SaveLST.fillSpaceRight(abund, 11);
                out.write(event);
                DictionaryData.DicRow dicRow = doc.dic.getRowByID(data.getID());
                String name = dicRow == null ? "NOT IN DICTIONARY" : dicRow.getName();
                out.write(String.valueOf(name) + "\r\n");
            }
            out.write("\r\n\r\n\r\n");
        }
    }

    public static String fillSpaceLeft(String s, int width) {
        String ret = s;
        while (ret.length() < width) {
            ret = " " + ret;
        }
        return ret;
    }

    public static String fillSpaceRight(String s, int width) {
        String ret = s;
        while (ret.length() < width) {
            ret = String.valueOf(ret) + " ";
        }
        return ret;
    }
}

